CREATE OR REPLACE FUNCTION sp_MoveTreeNode (VARCHAR, VARCHAR, VARCHAR)
RETURNS INTEGER AS $$
DECLARE
    pGuid ALIAS FOR $1;
    pOldParent ALIAS FOR $2;
    pNewParent ALIAS FOR $3;
    affected_rows INTEGER DEFAULT 0;
BEGIN

UPDATE tb_tree_node
SET parent_guid = pNewParent
WHERE guid = pGuid
  AND parent_guid = pOldParent
  AND pGuid IS NOT NULL
  AND pOldParent IS NOT NULL
  AND pNewParent IS NOT NULL
  AND pGuid NOT IN (SELECT tb_system_node.guid
                    FROM tb_system_node)
  AND pNewParent NOT IN (SELECT tb_system_node.guid
                         FROM tb_system_node
                         WHERE type_=1)
  AND (EXISTS(SELECT 1 FROM tb_tree_node
              WHERE guid=pGuid
                AND type_=2
                AND state IN ('UNMANAGED', 'MANAGED'))
      OR
       EXISTS(SELECT 1 FROM tb_tree_node
              WHERE guid=pGuid
                AND type_=1)
      )
  AND EXISTS(SELECT pNewParent FROM tb_tree_node
             WHERE guid=pNewParent
               AND type_=1)
  ;

GET DIAGNOSTICS affected_rows = ROW_COUNT;

UPDATE tb_tree_node
SET state='MANAGED'
WHERE affected_rows > 0
  AND guid = pGuid
  AND type_ = 2
  AND EXISTS(SELECT 1 FROM tb_system_node
             WHERE type_=3 -- unmanaged folder
              AND  guid=pOldParent);

UPDATE tb_tree_node
SET state='UNMANAGED'
WHERE affected_rows > 0
  AND guid = pGuid
  AND type_ = 2
  AND EXISTS(SELECT 1 FROM tb_system_node
             WHERE type_=3 -- unmanaged folder
              AND  guid=pNewParent);

RETURN affected_rows;
END;

$$ LANGUAGE plpgsql;
